/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1986 - 2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
/*
 * Name:
 *	SPMessageData.h
 *
 *
 * Purpose:
 *	Define SP Message Data.
 *
 * Distribution:
 *	PUBLIC
 *
 * Version history:
 *	1.0.0 4/1/1995	DL	First Version.
 *		Created by Adobe Systems Incorporated.
 */

#ifndef __SPMessageData__
#define __SPMessageData__


/*******************************************************************************
 **
 **	Imports
 **
 **/

#include "SPTypes.h"

#ifdef __cplusplus
extern "C" {
#endif


/*******************************************************************************
 **
 ** Types
 **
 **/

/* If the message data associated with a call to a plug-in has come from *
 * SPSendMessage, or is prepared using SetupMessageData(), this constant *
 * will be in the first four bytes of the message, in SPCheck.			 */
#define kSPValidSPMessageData 'SPCk'

typedef struct SPMessageData {

	long SPCheck;			/* kSPValidSPMessageData if a valid SPMessage */
	struct SPPlugin *self;  /* SPPluginRef */
	void *globals;
	struct SPBasicSuite *basic;

} SPMessageData;


#ifdef __cplusplus
}
#endif

#endif
